//Created by Sean Kane (http://celtickane.com/programming/code/ajax.php)
//Feather Ajax v1.0.1

function AjaxObject101() {
	this.createRequestObject = function() {	//This is called at the very bottom -- it sets this.http to the Ajax request object (ro)
		var ro;	//This will hold the request object -- either Microsoft.XMLHTTP or XMLHttpRequest
		try {	//Let's use a try/catch system just in case something goes wrong -- we can at least default back to the XMLHttpRequest object
			ro = new XMLHttpRequest();
		}
		catch (e) {
			ro = new ActiveXObject("Microsoft.XMLHTTP"); //We'll at least try the IE6 and lower version	
		}
		return ro;	//Now that we've taken care of cross-browser compatibility, this.http will represent the request object for this instance of AjaxObject
	}
	this.sndReq = function(action, url, data) { //This function will start the Ajax process, and is called manually by the user
		if (action.toUpperCase() == "POST") { //Post method
			this.http.open(action,url,true); //The URL includes any GET or POST variables you want
			this.http.setRequestHeader('Content-Type','application/x-www-form-urlencoded'); //Encode the data
			this.http.onreadystatechange = this.handleResponse; //This is the callback function when the state of the http object changes
			this.http.send(data);	//Actually start the request process -- this will contact the URL via the action specified, and wait to call this.handleResponse
		}
		else {	//'get' method is default
			this.http.open(action,url + '?' + data,true); //The URL includes any GET or POST variables you want
			this.http.onreadystatechange = this.handleResponse; //This is the callback function when the state of the http object changes
			this.http.send(null);	//Actually start the request process -- this will contact the URL via the action specified, and wait to call this.handleResponse
		}	
		//action is either 'get' or 'post'
		//url can contain GET variables -- like myajax.php?action=test
	}
	this.handleResponse = function() { //This function is called when this.http's state changes
		if ( me.http.readyState == 4) { //State of 4 means the connection is done (data was transferred)
			if (typeof me.funcDone == 'function') { me.funcDone(me);} //Execute the funcDone function if it's been set by the user
			
		}
		if ((me.http.readyState == 1) && (typeof me.funcWait == 'function')) { //This code will run if funcWait is pointed at a function -- this could call a spinner icon, or a "Please wait..." label
			me.funcWait();
		}
	}
	var me = this;	//Unfortunately, this is necessary because this.http won't work in the callback function 'handleResponse' (we have to use me.http instead)
	this.http = this.createRequestObject(); //http holds the request object (ro), which is returned from the createRequestObject() function -- this is automatically run when you make a new AjaxObject()
	
	var funcWait = null;
	var funcDone = null;
}